/*  AMX Mod X script
*                               ______                       __                    __          __                              ________
*		               / ____ \                      \ \                  / /         /  |                            |______  |
*		              / /    \ \                      \ \                / /         /   |                        __         | |
*		             | /      \ |                      \ \              / /         / /| |                       |__|        | |
*		             | |      | |    ______     _    __ \ \            / /  _      / / | |       ______                      | |
*    	 _   _____   _____   | |      | |   / ____ \   | |  / /  \ \          / /  |_|    / /  | |      / ____ \                     | |
*	| | / __  | / __  |  | |      | |  | /    \_\  | | / /    \ \        / /    _    / /   | |     /_/    \ \                    | |
*	| |/ /  | |/ /  | |  | |      | |  | \_____    | |/ /      \ \      / /    | |  / /____| |__     ______| |                   | |
*	| | /   | | /   | |  | |      | |   \_____ \   | | /        \ \    / /     | | /_______  |__|   / ____/| |                   | |
*	| |/    | |/    | |  | |      | |         \ |  | |/\         \ \  / /      | |         | |     / /     | |        __         | |
* 	| |     | |     | |  | \      / |  __     | |  | |\ \         \ \/ /       | |         | |    | |     /| |       |__|        | |
*	| |     | |     | |   \ \____/ /   \ \____/ |  | | \ \         \  /        | |         | |     \ \___/ /\ \       / /   _____| |
*	|_|     |_|     |_|    \______/     \______/   |_|  \_\         \/         |_|         |_|      \_____/  \_\     /_/   |_______|
*
*
*
*** Copyright 2011 - 2012, m0skVi4a ;]
*** Plugin created in Rousse, Bulgaria
*
*
*** Plugin thread 1:
*	https://forums.alliedmods.net/showthread.php?t=171460
*
*** Plugin thread 2:
*	http://amxmodxbg.org/forum/viewtopic.php?t=37116
*
*
*** Description:
*
*	This is Register System. You can put a password to your name and if someone connect to the server with the same name he will be kicked if he does not login.
*
*
*** Commands:
*
*	say /reg
*	say_team /reg
*	Open the register system menu
*
*
*** CVARS:
*
*	"rs_on"			- 	Is the plugin on(1) or off(0).   Default: 1
*	"rs_save_type"		-	Where to seve the information: to file(0) or to MySQL(1).   Default: 0
*	"rs_host"    		-	The host for the database.   Default: 127.0.0.1
*	"rs_user"	 	-	The username for the database login.   Default: root
*	"rs_pass"		-	The password for the database login.   Default:
*	"rs_db" 		- 	The database name.   Default: registersystem
*	"rs_password_prefix"	-	The prefix of the setinfo for the Auto Login function.   Default: _rspass
*	"rs_register_time"  	- 	How much time has the client to register. If is set to 0 registration is not mandatory.   Default: 0
*	"rs_login_time" 	- 	How much time has the client to login if is registered.   Default: 60.0
*	"rs_password_len"	-	What is minimum length of the password.   Default: 6
*	"rs_attempts"  		- 	How much attempts has the client to login if he type wrong password.   Default: 3
*	"rs_chngpass_times"	-	How much times can the client change his password per map.   Default: 3
*	"rs_register_log"	-	Is it allowed the plugin to log in file when the client is registered.   Default: 1
*	"rs_chngpass_log"	-	Is it allowed the plugin to log in file when the client has change his password.   Default: 1
*	"rs_autologin_log"	- 	Is it allowed the plugin to log in file when the client has change his Auto Login function.   Default: 1
*	"rs_blind"		-	Whether clients who have not Logged or who must Register be blinded.   Default: 1
*	"rs_commands"		-	Whether clients who have not Logged or who must Register commands' be blocked.   Default: 1
*	"rs_logout"		-	What to do when client Logout - kick him from the server(0) or wait to Login during the Login time(1).   Default: 0
*	"rs_count"		-	Is the countig when you have to register or you have to login on(1) or off(0).   Default: 1
*	"rs_advert"		-	Is the advertisement for not registered players on(1) or off(0).   Default: 1
*	"rs_advert_int"		-	What is the interval between two advertisements in seconds.   Default: 60
*	"rs_ajc_team"		-	Is the Auto Join On Connect option on(1, 2, 5, 6) or off(0). 1 is Terrorists, 2 is Counter-Terrorsits, 6 Spectators, 5 Auto Assign.   Default: 0
*	"rs_ajc_class_t"	-	Which class the Terrorists will be (AJC must be on) - 1 is Terror, 2 is Leet, 3 is Artic, 4 is Guerilla, 5 is Auto Sellect, if it is set to 0 playes can choose which class they wiil be.   Default: 5
*	"rs_ajc_class_ct"	-	Which class the Counter-Terrorists will be (AJC must be on) - 1 is Urban, 2 is GSG-9, 3 is SAS, 4 is GIGN, 5 is Auto Sellect, if it is set to 0 playes can choose which class they wiil be.   Default: 5
*	"rs_ajc_admin"		-	Is it allowed players with defined flag (Default: ADMIN_IMMUNITY) can choose in which team will they be (AJC must be on).   Default: 1
*	"rs_ajc_change"		-	Is it allowed players to change their team(0) or not(1).   Default: 0
*	"rs_remember_punish_by"	-	How to remember the punished players: by Nmae(0), by IP(1) or by SteamID(2).   Default: 0
*	"rs_cant_login_time"	-	How much time in seconds players can't login after typing wrong passwrods.   Default: 300
*	"rs_cant_change_pass_time"	- How much time in seconds players can't change their paswords after changing it before that.   Default: 300
*
*	All CVARS are without quotes!
*
*
*** Credits:
*
* 	m0skVi4a ;]    	-	for the idea of the plugin and its creation
* 	ConnorMcLeod 	- 	for his help to block the name change for logged clients
*	Sylwester	-	for the idea for the encrypt
*	dark_style	-	for ideas in the plugin
* 	Vasilii-Zaicev	-	for testing the plugin
*
*
*** Changelog:
*
*	November 6, 2011   -  V1.0 BETA:
*		-  First Release
*
*	November 20, 2011   -  V1.1 FINAL
*		-  Fixed some bugs
*		-  Added change Password function
*		-  Added Info/Help
*		-  Added cvars to show when the client is registered and change his password
*		-  Password are now encrypted for more safety
*
*	November 23, 2011   -  V1.1 FINAL FIX 1
*	-  Fixed bug if the client type more than CVAR setted attempts passwords
*
*	November 28, 2011   -  V1.1 FINAL FIX 2
*		-  Fixed bug if that the menu does not pop up when user connect
*
*	December 26, 2011   -  V2.0
*		-  Fixed bug if player change his name and the system does not check the new name
*		-  Added block chooseteam if the client is registered but not logged
*		-  Added MySQL support
*		-  Added .cfg file to manually set the settings of the system
*		-  Added CVAR for setting which clients can change their names
*		-  Added auto login on changelevel or client retry
*
*	December 27, 2011   -  V2.0 FIX 1
*		-  Fixed bug with the kick function
*
*	January 3, 2012   -  V2.0 FIX 2
*		-  Fixed bug with the auto login function that does not work on Steam clients
*
*	January 24, 2012   -  V3.0
*		-  Fixed bug with the MYSQL Connection
*		-  Added new style of the Change Password function
*		-  Removed some CVARs and added new
*		-  Now in the Register System file or into MYSQL table is not saving the date and time for registering or for changing password for the client. They are saving in special log file with name register_system_log.txt
*
*	February 17, 2012   -  V4.0
*		-  Fixed some little bugs
*		-  Added new style of the main menu
*		-  Removed the possibility of SQL Injection
*		-  The whole name change function is rewritten
*		-  Added option for the not registered and not logged clients to be blinded
*		-  Added option for the not registered and not logged clients chat's to be blocked
*		-  Added showing information in the consoles of the clients about why they are kicked
*
*	February 19, 2012   -  V4.0 FIX 1
*		-  Fixed bug with the join in the Spectator team
*		-  Added the Auto Assign option in the main menu
*		-  Small rewrite of the Auto Login function
*
*	March 7, 2012   -  V5.0
*		-  Fixed bug with % that replace the space in the name of the client
*		-  Fixed the bug with the menu that stands when client choose team
*		-  Fixed some little bugs
*		-  Added new style of the main menu
*
*	August 4, 2012   -  V6.0
*		-  Fixed bug which the plugin changes player names sometimes
*		-  Fixed bug when the main menu sometimes appears on new round and it can't be choosen an option
*		-  Added live counter to count how many seconds does the player has to Login or Register
*		-  Added Auto Join On Connect (AJC) options.
*		-  Added plugin natives for API plugins
*		-  Added Advertisement for players which are not registered
*		-  Now the plugin doesn't use the team menu and it can be used in other mods like Zombie Plague
*		-  Some functions are rewritten for better work of the plugin
*		-  The Optiosn Menu is removed and its options are in the new style Main Menu
*
*	September 14, 2012   -  V7.0
*		-  Fixed bug with passwords conflicts
*		-  Fixed bug with the Auto Login function
*		-  Fixed bug with the Auto join function
*		-  Fixed bug with the Name Change function
*		-  Added file with listed commands which players can not use until they login
*		-  Added reconnect Support for the Login functions
*		-  Added reconnect Support for the Change Password function
*		-  Added some features for the Auto Join function
*		-  Added more stylish way for executing the configuration files
*
*** Contact me on:
*	E-MAIL: pvldimitrov@gmail.com
*	SKYPE: pa7ohin
*/

#include <amxmodx>
#include <celltrie>
#include <cstrike>
#include <fakemeta>
#include <hamsandwich>
#include <sqlx>

#define VERSION "7.0"
#define TASK_MESS 1000
#define TASK_KICK 2000
#define TASK_MENU 3000
#define TASK_TIMER 4000
#define TASK_ADVERT 5000
#define TASK_AJC 6000
#define MENU_TASK_TIME 0.5
#define AJC_TASK_TIME 0.1
#define AJC_ADMIN_FLAG ADMIN_IMMUNITY
#define SALT "8c4f4370c53e0c1e1ae9acd577dddbed"

//Start of CVAR pointers
new g_on;
new g_save;
new g_host;
new g_user;
new g_pass;
new g_db;
new g_setinfo_pr;
new g_regtime;
new g_logtime;
new g_pass_length;
new g_attempts;
new g_chp_time;
new g_reg_log;
new g_chp_log;
new g_aulog_log;
new g_blind;
new g_comm;
new g_logout;
new g_count
new g_advert;
new g_advert_int;
new g_ajc_team;
new g_ajc_admin;
new g_ajc_class[2];
new g_ajc_change;
new g_member;
new g_time;
new g_time_pass;
//End of CVAR pointers

//Start of Arrays
new reg_file[256];
new line = 0;
new text[512];
new params[2];
new check_name[32];
new check_pass[34];
new check_status[11];
new query[512];
new Handle:g_sqltuple;
new password[33][34];
new typedpass[32];
new new_pass[33][32];
new hash[34];
new pass_prefix[32];
new attempts[33];
new times[33];
new g_player_name[33][32];
new g_player_time[33];
new g_client_data[33][35];
new value;
new menu[512];
new keys;
new length;
new g_saytxt
new g_screenfade
new g_sync_hud
//End fo Arrays

//Start of Booleans
new bool:is_logged[33];
new bool:is_registered[33];
new bool:is_autolog[33];
new bool:cant_change_pass[33];
new bool:name_change[33];
//End of Booleans

//Start of Trie handles
new Trie:g_commands;
new Trie:g_login_times;
new Trie:g_cant_login_time;
new Trie:g_pass_change_times;
new Trie:g_cant_change_pass_time;
//End of Trie handles

//Start of Constants
new const prefix[] = "[REGISTER SYSTEM]";
new const log_file[] = "register_system_log.txt";
new const JOIN_TEAM_MENU_FIRST[] = "#Team_Select";
new const JOIN_TEAM_MENU_FIRST_SPEC[] = "#Team_Select_Spect";
new const JOIN_TEAM_MENU_INGAME[] = "#IG_Team_Select";
new const JOIN_TEAM_MENU_INGAME_SPEC[] = "#IG_Team_Select_Spect"; 
new const JOIN_TEAM_VGUI_MENU = 2;

//Start of CVARs
new const g_cvars[29][] =
{
	"rs_on",
	"rs_save_type",
	"rs_host",
	"rs_user",
	"rs_pass",
	"rs_db",
	"rs_password_prefix",
	"rs_register_time",
	"rs_login_time",
	"rs_password_len",
	"rs_attempts",
	"rs_chngpass_times",
	"rs_register_log",
	"rs_chngpass_log",
	"rs_autologin_log",
	"rs_blind",
	"rs_commands",
	"rs_logout",
	"rs_count",
	"rs_advert",
	"rs_advert_int",
	"rs_ajc_team",
	"rs_ajc_class_t",
	"rs_ajc_class_ct",
	"rs_ajc_admin",
	"rs_ajc_change",
	"rs_remember_punish_by",
	"rs_cant_login_time",
	"rs_cant_change_pass_time"
};
//End of CVARs
//End of Constants

/*==============================================================================
	Start of Plugin Init
================================================================================*/
public plugin_init() 
{
	register_plugin("Register System", VERSION, "m0skVi4a ;]")

	g_on = register_cvar(g_cvars[0], "1")
	g_save = register_cvar(g_cvars[1], "0")
	g_host = register_cvar(g_cvars[2], "127.0.0.1")
	g_user = register_cvar(g_cvars[3], "root")
	g_pass = register_cvar(g_cvars[4], "123456")
	g_db = register_cvar(g_cvars[5], "registersystem")
	g_setinfo_pr = register_cvar(g_cvars[6], "_rspass")
	g_regtime = register_cvar(g_cvars[7], "0")
	g_logtime = register_cvar(g_cvars[8], "60.0")
	g_pass_length = register_cvar(g_cvars[9], "6")
	g_attempts = register_cvar(g_cvars[10], "3")
	g_chp_time = register_cvar(g_cvars[11], "3")
	g_reg_log = register_cvar(g_cvars[12], "1")
	g_chp_log = register_cvar(g_cvars[13], "1")
	g_aulog_log = register_cvar(g_cvars[14], "1")
	g_blind = register_cvar(g_cvars[15], "1")
	g_comm = register_cvar(g_cvars[16], "1")
	g_logout = register_cvar(g_cvars[17], "0")
	g_count = register_cvar(g_cvars[18], "1")
	g_advert = register_cvar(g_cvars[19], "1")
	g_advert_int = register_cvar(g_cvars[20], "60")
	g_ajc_team = register_cvar(g_cvars[21], "0")
	g_ajc_class[0] = register_cvar(g_cvars[22], "5")
	g_ajc_class[1] = register_cvar(g_cvars[23], "5")
	g_ajc_admin = register_cvar(g_cvars[24], "1")
	g_ajc_change = register_cvar(g_cvars[25], "0")
	g_member = register_cvar(g_cvars[26], "0")
	g_time = register_cvar(g_cvars[27], "300")
	g_time_pass = register_cvar(g_cvars[28], "300")

	register_message(get_user_msgid("ShowMenu"), "TextMenu")
	register_message(get_user_msgid("VGUIMenu"), "VGUIMenu")
	register_menucmd(register_menuid("Register System Main Menu"), 1023, "HandlerMainMenu")
	register_menucmd(register_menuid("Password Menu"), 1023, "HandlerConfirmPasswordMenu")
	register_clcmd("jointeam", "HookTeamCommands")
	register_clcmd("chooseteam", "HookTeamCommands")
	register_clcmd("LOGIN_PASS", "Login")
	register_clcmd("REGISTER_PASS", "Register")
	register_clcmd("CHANGE_PASS_NEW", "ChangePasswordNew")
	register_clcmd("CHANGE_PASS_OLD", "ChangePasswordOld")
	register_clcmd("AUTO_LOGIN_PASS", "AutoLoginPassword")
	RegisterHam(Ham_Spawn, "player", "HookPlayerSpawn", 1)
	register_forward(FM_PlayerPreThink, "PlayerPreThink")
	register_forward(FM_ClientUserInfoChanged, "ClientInfoChanged")

	register_dictionary("register_system.txt")
	g_saytxt = get_user_msgid("SayText")
	g_screenfade = get_user_msgid("ScreenFade")
	g_sync_hud = CreateHudSyncObj()
	g_commands = TrieCreate()
	g_login_times = TrieCreate()
	g_cant_login_time = TrieCreate()
	g_pass_change_times = TrieCreate()
	g_cant_change_pass_time = TrieCreate()
}
/*==============================================================================
	End of Plugin Init
================================================================================*/

/*==============================================================================
	Start of Plugin Natives
================================================================================*/
public plugin_natives()
{
	register_library("register_system")
	register_native("is_registered", "_is_registered")
	register_native("is_logged", "_is_logged")
	register_native("is_autologged", "_is_autologged")
	register_native("get_cant_login_time", "_get_cant_login_time")
	register_native("get_cant_change_pass_time", "_get_cant_change_pass_time")
}

public _is_registered(plugin, parameters)
{
	if(parameters != 1)
		return false

	new id = get_param(1)

	if(!id)
		return false

	if(is_registered[id])
	{
		return true
	}

	return false
}

public _is_logged(plugin, parameters)
{
	if(parameters != 1)
		return false

	new id = get_param(1)

	if(!id)
		return false

	if(is_logged[id])
	{
		return true
	}

	return false
}

public _is_autologged(plugin, parameters)
{
	if(parameters != 1)
		return -1

	new id = get_param(1)

	if(!id)
		return -1

	if(is_autolog[id])
	{
		return true
	}

	return false
}

public _get_cant_login_time(plugin, parameters)
{
	if(parameters != 1)
		return -1

	new id = get_param(1)

	if(!id)
		return -1

	new data[35];

	switch(get_pcvar_num(g_member))
	{
		case 0:
		{
			get_user_name(id, data, charsmax(data))
		}
		case 1:
		{
			get_user_ip(id, data, charsmax(data))
		}
		case 2:
		{
			get_user_authid(id, data, charsmax(data))
		}		
		default:
		{
			get_user_name(id, data, charsmax(data))
		}
	}

	if(TrieGetCell(g_cant_login_time, data, value))
	{
		new cal_time = get_pcvar_num(g_time) - (time() - value)
		return cal_time
	}

	return -1
}

public _get_cant_change_pass_time(plugin, parameters)
{
	if(parameters != 1)
		return -1

	new id = get_param(1)

	if(!id)
		return -1

	new data[35];

	switch(get_pcvar_num(g_member))
	{
		case 0:
		{
			get_user_name(id, data, charsmax(data))
		}
		case 1:
		{
			get_user_ip(id, data, charsmax(data))
		}
		case 2:
		{
			get_user_authid(id, data, charsmax(data))
		}		
		default:
		{
			get_user_name(id, data, charsmax(data))
		}
	}

	if(TrieGetCell(g_cant_change_pass_time, data, value))
	{
		new cal_time = get_pcvar_num(g_time_pass) - (time() - value)
		return cal_time
	}

	return -1
}
/*==============================================================================
	End of Plugin Natives
================================================================================*/

/*==============================================================================
	Start of Executing plugin's config and choose the save mode
================================================================================*/
public plugin_cfg()
{
	if(!get_pcvar_num(g_on))
		return PLUGIN_HANDLED

	new const separator_1[] = "==============================================================================="
	new const separator_2[] = "-------------------------------------------------------------------------------"

	server_print(" ")
	server_print(separator_1)
	server_print("Title	: Register System")
	server_print("Version	: %s", VERSION)
	server_print("Author	: m0skVi4a ;]")
	server_print("Site	: https://forums.alliedmods.net/showthread.php?t=171460")
	server_print(separator_2)

	new configs_dir[64], cfg_file[256], commands_file[256], i_time[9], bool:error = false, count;

	get_localinfo("amxx_configsdir", configs_dir, charsmax(configs_dir))
	formatex(cfg_file, charsmax(cfg_file), "%s/registersystem.cfg", configs_dir)
	formatex(commands_file, charsmax(commands_file), "%s/registersystem_commands.ini", configs_dir)
	get_time("%H:%M:%S", i_time, charsmax(i_time))

	if(!file_exists(cfg_file))
	{
		server_print("[%s] [ERROR] > File registersystem.cfg not found!", i_time)
	}
	else
	{
		server_print("[%s] > Loading settings from registersystem.cfg", i_time)

		line = 0, length = 0, count = 0;

		while(read_file(cfg_file, line++ , text, charsmax(text), length))
		{
			if(!text[0] || text[0] == '^n' || text[0] == ';' || (text[0] == '/' && text[1] == '/'))
				continue

			new cvar[32], param[32], bool:error_1 = true, bool:error_2 = true

			trim(text)
			parse(text, cvar, charsmax(cvar), param, charsmax(param))

			for(new i = 0; i <= 28; i++)
			{
				if(equal(cvar, g_cvars[i]))
				{
					error_1 = false
				}
			}

			if(param[0] && !(equali(param, " ")))
			{
				error_2 = false
			}

			if(error_1)
			{
				server_print("[%s] [ERROR] > Unknown CVAR ^"%s^"", i_time, cvar)
				error = true
			}
			else
			{
				if(error_2)
				{
					server_print("[%s] [ERROR] > Bad value for ^"%s^"", i_time, cvar)
					error = true
				}
				else
				{
					server_print("[%s] [OK] > Read cvar ^"%s^" ^"%s^"", i_time, cvar, param)
					server_cmd("%s %s", cvar, param)
					count++
				}
			}
		}

		if(!count)
		{
			server_print("[%s] [ERROR] > There were no CVARs in registersystem.cfg", i_time)
			error = true
		}
	}
	
	if(get_pcvar_num(g_comm))
	{
		if(!file_exists(commands_file))
		{
			server_print("[%s] [ERROR] > File registersystem_commands.ini not found!", i_time)
		}
		else
		{
			server_print("[%s] > Loading settings from registersystem_commands.ini", i_time)

			line = 0, length = 0, count = 0;

			while(read_file(commands_file, line++ , text, charsmax(text), length))
			{
				if(!text[0] || text[0] == '^n' || text[0] == ';' || (text[0] == '/' && text[1] == '/'))
				continue

				trim(text)
				parse(text, text, charsmax(text))

				TrieSetCell(g_commands, text, 1)
				count++
			}

			if(count)
			{
				server_print("[%s] [OK] > %d command%s loaded!", i_time, count, count > 1 ? "s" : "")
			}
			else
			{
				server_print("[%s] [ERROR] > There were no commands in registersystem_commands.ini", i_time)
				error = true
			}
		}
	}

	server_print(separator_2)

	if(error)
	{
		server_print("[%s] [WARNING] > Reading some data from configuration file failes!", i_time)
		server_print("> Please check [ERROR] messages above for solving this problem!")
	}
	else
	{
		server_print("[%s] [OK] > All settings loaded successfully!", i_time)
	}

	server_print(separator_1)
	server_print(" ")

	if(get_pcvar_num(g_save))
	{
		new host[64], user[32], pass[32], db[128];

		get_pcvar_string(g_host, host, charsmax(host))
		get_pcvar_string(g_user, user, charsmax(user))
		get_pcvar_string(g_pass, pass, charsmax(pass))
		get_pcvar_string(g_db, db, charsmax(db))

		g_sqltuple = SQL_MakeDbTuple(host, user, pass, db)

		formatex(query, charsmax(query), "CREATE TABLE IF NOT EXISTS registersystem (Name VARCHAR(32), Password VARCHAR(34), Status VARCHAR(10))")
	}
	else
	{
		formatex(reg_file, charsmax(reg_file), "%s/regusers.ini", configs_dir)

		if(!file_exists(reg_file))
		{
			write_file(reg_file,";Register System file^n;Modifying may cause the clients to can not Login!^n^n")
			server_print("%s Could not find Register System file -  %s   Creating new...", prefix, reg_file)
		}
	}
	return PLUGIN_CONTINUE
}

public QueryCreateTable(failstate, Handle:query, error[], errcode, data[], datasize, Float:queuetime)
{
	if(failstate == TQUERY_CONNECT_FAILED)
	{
		set_fail_state("[REGISTER SYSTEM] Could not connect to database!")
	}
	else if(failstate == TQUERY_QUERY_FAILED)
	{
		set_fail_state("[REGISTER SYSTEM] Query failed!")
	}
	else if(errcode)
	{
		server_print("%s Error on query: %s", prefix, error)
	}
	else
	{
		server_print("%s MYSQL connection succesful!", prefix)
	}
}
/*==============================================================================
	End of Executing plugin's config and choose the save mode
================================================================================*/

/*==============================================================================
	Start of plugin's end function
================================================================================*/
public plugin_end()
{
	TrieDestroy(g_commands)
	TrieDestroy(g_login_times)
	TrieDestroy(g_cant_login_time)
	TrieDestroy(g_pass_change_times)
	TrieDestroy(g_cant_change_pass_time)
}
/*==============================================================================
	End of plugin's end function
================================================================================*/

/*==============================================================================
	Start of Client's connect and disconenct functions
================================================================================*/
public client_connect(id)
{
	is_logged[id] = false
	is_registered[id] = false
	is_autolog[id] = false
	cant_change_pass[id] = false
	name_change[id] = false
	attempts[id] = 0
	times[id] = 0
	remove_task(id+TASK_MESS)
	remove_task(id+TASK_KICK)
	remove_task(id+TASK_MENU)
	remove_task(id+TASK_TIMER)
	remove_task(id+TASK_ADVERT)
	remove_task(id+TASK_AJC)
	get_user_name(id, g_player_name[id], charsmax(g_player_name))
	CheckClient(id)
}

public client_authorized(id)
{
	switch(get_pcvar_num(g_member))
	{
		case 0:
		{
			get_user_name(id, g_client_data[id], charsmax(g_client_data))
		}
		case 1:
		{
			get_user_ip(id, g_client_data[id], charsmax(g_client_data))
		}
		case 2:
		{
			get_user_authid(id, g_client_data[id], charsmax(g_client_data))
		}		
		default:
		{
			get_user_name(id, g_client_data[id], charsmax(g_client_data))
		}
	}

	if(TrieGetCell(g_login_times, g_client_data[id], value))
	{
		attempts[id] = value

		if(attempts[id] >= get_pcvar_num(g_attempts))
		{
			params[0] = id
			params[1] = 2
			set_task(1.0, "KickPlayer", id+TASK_KICK, params, sizeof params)
		}
	}

	if(TrieGetCell(g_pass_change_times, g_client_data[id], value))
	{
		times[id] = value

		if(times[id] >= get_pcvar_num(g_chp_time))
		{
			cant_change_pass[id] = true
		}
	}
}

public client_putinserver(id)
{
	ShowMsg(id)
	set_task(get_pcvar_float(g_advert_int), "ShowAdvert", id+TASK_ADVERT)
}

public client_disconnect(id)
{
	is_logged[id] = false
	is_registered[id] = false
	is_autolog[id] = false
	cant_change_pass[id] = false
	name_change[id] = false
	attempts[id] = 0
	times[id] = 0
	remove_task(id+TASK_MESS)
	remove_task(id+TASK_KICK)
	remove_task(id+TASK_MENU)
	remove_task(id+TASK_TIMER)
	remove_task(id+TASK_ADVERT)
	remove_task(id+TASK_AJC)
}
/*==============================================================================
	End of Client's connect and disconenct functions
================================================================================*/

/*==============================================================================
	Start of Check Client functions
================================================================================*/
public CheckClient(id)
{
	if(!get_pcvar_num(g_on) || is_user_bot(id))
		return PLUGIN_HANDLED

	remove_task(id+TASK_KICK)
	is_registered[id] = false
	is_logged[id] = false
	is_autolog[id] = false

	if(get_pcvar_num(g_save))
	{
		new data[1]
		data[0] = id

		formatex(query, charsmax(query), "SELECT `Password`, `Status` FROM `registersystem` WHERE Name = ^"%s^";", g_player_name[id])

		SQL_ThreadQuery(g_sqltuple, "QuerySelectData", query, data, 1)
	}
	else
	{
		line = 0, length = 0;

		while(read_file(reg_file, line++ , text, charsmax(text), length))
		{
			if(!text[0] || text[0] == '^n' || text[0] == ';')
				continue

			parse(text, check_name, charsmax(check_name), check_pass, charsmax(check_pass), check_status, charsmax(check_status))

			if(!(equal(check_name, g_player_name[id])))
				continue

			is_registered[id] = true
			password[id] = check_pass

			if(equal(check_status, "LOGGED_IN"))
			{
				is_autolog[id] = true
				CheckAutoLogin(id)
			}

			if(is_user_connected(id))
			{
				user_silentkill(id)
				cs_set_user_team(id, CS_TEAM_UNASSIGNED)
				ShowMsg(id)
			}

			break
		}
	}
	return PLUGIN_CONTINUE
}

public QuerySelectData(FailState, Handle:Query, error[], errorcode, data[], datasize, Float:fQueueTime)
{ 
	if(FailState == TQUERY_CONNECT_FAILED || FailState == TQUERY_QUERY_FAILED)
	{
		log_amx("%s", error)
		return
	}
	else
	{
		new id = data[0];
		new col_pass = SQL_FieldNameToNum(Query, "Password")
		new col_status = SQL_FieldNameToNum(Query, "Status")

		while(SQL_MoreResults(Query)) 
		{
			SQL_ReadResult(Query, col_pass, check_pass, charsmax(check_pass))
			SQL_ReadResult(Query, col_status, check_status, charsmax(check_status))
			is_registered[id] = true
			password[id] = check_pass

			if(equal(check_status, "LOGGED_IN"))
			{
				is_autolog[id] = true
				CheckAutoLogin(id)
			}

			if(is_user_connected(id))
			{
				user_silentkill(id)
				cs_set_user_team(id, CS_TEAM_UNASSIGNED)
				ShowMsg(id)
			}

			SQL_NextRow(Query)
		}
	}
}

public CheckAutoLogin(id)
{
	new client_password[32];

	get_pcvar_string(g_setinfo_pr, pass_prefix, charsmax(pass_prefix))
	get_user_info(id, pass_prefix, client_password, charsmax(client_password))
	hash = convert_password(client_password)

	if(equal(hash, password[id]))
	{
		is_logged[id] = true
	}
	else
	{
		is_autolog[id] = false
	}
}
/*==============================================================================
	End of Check Client functions
================================================================================*/

/*==============================================================================
	Start of Show Client's informative messages
================================================================================*/
public ShowMsg(id)
{
	if(!get_pcvar_num(g_on))
		return PLUGIN_HANDLED

	set_task(5.0, "Messages", id+TASK_MESS)

	params[0] = id

	if(!is_registered[id])
	{
		if(get_pcvar_float(g_regtime) != 0)
		{
			CreateMainMenuTask(id+TASK_MENU)

			if(get_pcvar_num(g_count))
			{
				g_player_time[id] = get_pcvar_num(g_regtime)
				ShowTimer(id+TASK_TIMER)
			}
			params[1] = 1
			set_task(get_pcvar_float(g_regtime) + 3, "KickPlayer", id+TASK_KICK, params, sizeof params)
			return PLUGIN_HANDLED
		}
	}
	else if(!is_logged[id])
	{
		CreateMainMenuTask(id+TASK_MENU)

		if(get_pcvar_num(g_count))
		{
			g_player_time[id] = get_pcvar_num(g_logtime)
			ShowTimer(id+TASK_TIMER)
		}
		params[1] = 2
		set_task(get_pcvar_float(g_logtime) + 3, "KickPlayer", id+TASK_KICK, params, sizeof params)
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public ShowTimer(id)
{
	id -= TASK_TIMER

	if(!is_user_connected(id))
		return PLUGIN_HANDLED

	switch(g_player_time[id])
	{
		case 10..19:
		{
			set_hudmessage(255, 255, 0, -1.0, -1.0, 0, 0.02, 1.0,_,_, -1)
		}
		case 0..9:
		{
			set_hudmessage(255, 0, 0, -1.0, -1.0, 1, 0.02, 1.0,_,_, -1)
		}
		default:
		{
			set_hudmessage(0, 255, 0, -1.0, -1.0, 0, 0.02, 1.0,_,_, -1)
		}
	}

	if(!g_player_time[id])
	{
		ShowSyncHudMsg(id, g_sync_hud, "%L", LANG_SERVER, "KICK_HUD")
		return PLUGIN_CONTINUE
	}
	else if(!is_registered[id] && get_pcvar_float(g_regtime))
	{
		ShowSyncHudMsg(id, g_sync_hud, "%L", LANG_SERVER, g_player_time[id] > 1 ? "REGISTER_HUD" : "REGISTER_HUD_SEC", g_player_time[id])
	}
	else if(is_registered[id] && !is_logged[id])
	{
		ShowSyncHudMsg(id, g_sync_hud, "%L ", LANG_SERVER, g_player_time[id] > 1 ? "LOGIN_HUD" : "LOGIN_HUD_SEC", g_player_time[id])
	}
	else return PLUGIN_HANDLED

	g_player_time[id]--

	set_task(1.0, "ShowTimer", id+TASK_TIMER)

	return PLUGIN_CONTINUE
}

public Messages(id)
{
	id -= TASK_MESS

	if(!is_registered[id])
	{
		if(get_pcvar_float(g_regtime) != 0)
		{
			client_printcolor(id, "%L", LANG_SERVER, "REGISTER_CHAT", prefix, get_pcvar_num(g_regtime))
		}
		else
		{
			client_printcolor(id, "%L", LANG_SERVER, "YOUCANREG_CHAT", prefix)
		}
	}
	else if(!is_logged[id])
	{
		client_printcolor(id, "%L", LANG_SERVER, "LOGIN_CHAT", prefix, get_pcvar_num(g_logtime))
	}
	else if(is_autolog[id])
	{
		client_printcolor(id, "%L", LANG_SERVER, "AUTO_LOGIN_CHAT", prefix)
	}
}
/*==============================================================================
	End of Show Client's informative messages
================================================================================*/

/*==============================================================================
	Start of Client's Auto Login Changer function
================================================================================*/
public AutoLoginPassword(id)
{
	if(!get_pcvar_num(g_on))
		return PLUGIN_HANDLED

	read_args(typedpass, charsmax(typedpass))
	remove_quotes(typedpass)

	hash = convert_password(typedpass)

	if(!equal(hash, password[id]))
	{
		TrieSetCell(g_login_times, g_client_data[id], ++attempts[id])
		client_printcolor(id, "%L", LANG_SERVER, "LOG_PASS_INVALID", prefix, attempts[id], get_pcvar_num(g_attempts))

		if(attempts[id] >= get_pcvar_num(g_attempts))
		{
			if(get_pcvar_num(g_count))
			{
				g_player_time[id] = 0
				ShowTimer(id+TASK_TIMER)
			}

			if(get_pcvar_num(g_time))
			{
				TrieSetCell(g_cant_login_time, g_client_data[id], time())
			}
			else
			{
				TrieSetCell(g_cant_login_time, g_client_data[id], 0)
			}
			params[0] = id
			params[1] = 3
			set_task(2.0, "KickPlayer", id+TASK_KICK, params, sizeof params)

			if(get_pcvar_num(g_time))
			{	
				set_task(get_pcvar_float(g_time), "RemoveCantLogin", 0, g_client_data[id], sizeof g_client_data)
			}
			return PLUGIN_HANDLED
		}
		else
		{
			client_cmd(id, "messagemode AUTO_LOGIN_PASS")
		}

		return PLUGIN_HANDLED
	}
	else
	{
		get_pcvar_string(g_setinfo_pr, pass_prefix, charsmax(pass_prefix))
		client_cmd(id, "setinfo %s %s", pass_prefix, typedpass)
		AutoLogin(id, true)
		MainMenu(id)
	}
	return PLUGIN_CONTINUE
}

AutoLogin(id, bool:enabled = true)
{
	if(!is_registered[id] || !is_logged[id])
		return PLUGIN_HANDLED

	if(get_pcvar_num(g_save))
	{
		formatex(query, charsmax(query), "UPDATE registersystem SET Status = ^"%s^" WHERE Name = ^"%s^";", enabled ? "LOGGED_IN" : "LOGGED_OUT", g_player_name[id])
		SQL_ThreadQuery(g_sqltuple, "QuerySetData", query)
	}
	else
	{
		line = 0, length = 0;

		while(read_file(reg_file, line++ , text, charsmax(text), length))
		{
			parse(text, text, charsmax(text))

			if(!(equal(text, g_player_name[id])))
				continue

			formatex(text, charsmax(text), "^"%s^" ^"%s^" ^"%s^"", g_player_name[id], password[id], enabled ? "LOGGED_IN" : "LOGGED_OUT")
			write_file(reg_file, text, line - 1)							

			break
		}
	}

	if(enabled)
	{
		is_autolog[id] = true
		client_printcolor(id, "%L", LANG_SERVER, "AUTO_LOGIN_ON", prefix)

		if(get_pcvar_num(g_aulog_log))
		{
			log_to_file(log_file, "%L", LANG_SERVER, "LOGFILE_AUTO_ON", g_player_name[id])
		}
	}
	else
	{
		is_autolog[id] = false
		client_printcolor(id, "%L", LANG_SERVER, "AUTO_LOGIN_OFF", prefix)
		get_pcvar_string(g_setinfo_pr, pass_prefix, charsmax(pass_prefix))
		client_cmd(id, "setinfo %s ^"^"", pass_prefix)
		
		if(get_pcvar_num(g_aulog_log))
		{
			log_to_file(log_file, "%L", LANG_SERVER, "LOGFILE_AUTO_OFF", g_player_name[id])
		}
	}

	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Client's Auto Login Changer function
================================================================================*/

/*==============================================================================
	Start of the Main Menu function
================================================================================*/
public CreateMainMenuTask(id)
{
	id -= TASK_MENU

	if((!is_registered[id] && get_pcvar_float(g_regtime)) || (is_registered[id] && !is_logged[id]))
	{
		MainMenu(id)
		set_task(MENU_TASK_TIME, "CreateMainMenuTask", id+TASK_MENU)
	}
}

public MainMenu(id)
{
	if(!get_pcvar_num(g_on) || !is_user_connected(id))
		return PLUGIN_HANDLED

	length = 0

	if(is_registered[id])
	{
		if(is_logged[id])
		{
			length += formatex(menu[length], charsmax(menu) - length, "%L", LANG_SERVER, "MAIN_MENU_LOG", LANG_SERVER, is_autolog[id] ? "AUTO_LOG_DIS" : "AUTO_LOG_EN")
			keys = MENU_KEY_1|MENU_KEY_4|MENU_KEY_5|MENU_KEY_9|MENU_KEY_0
		}
		else
		{
			length += formatex(menu[length], charsmax(menu) - length, "%L", LANG_SERVER, "MAIN_MENU_REG")
			keys = MENU_KEY_1|MENU_KEY_9
		}
	}
	else
	{		
		if(get_pcvar_float(g_regtime) == 0)
		{
			length += formatex(menu[length], charsmax(menu) - length, "%L", LANG_SERVER, "MAIN_MENU_NOTREG")
			keys = MENU_KEY_2|MENU_KEY_9|MENU_KEY_0
		}
		else
		{
			length += formatex(menu[length], charsmax(menu) - length, "%L", LANG_SERVER, "MAIN_MENU_NOTREG_FORCE")
			keys = MENU_KEY_2|MENU_KEY_9
		}
	}
	show_menu(id, keys, menu, -1, "Register System Main Menu")

	return PLUGIN_CONTINUE
}

public HandlerMainMenu(id, key)
{
	switch(key)
	{
		case 0:
		{
			if(!is_logged[id])
			{
				client_cmd(id, "messagemode LOGIN_PASS")
			}
			else
			{
				is_logged[id] = false

				if(is_autolog[id])
				{
					AutoLogin(id)
				}

				if(get_pcvar_num(g_logout))
				{
					ShowMsg(id)
					CreateMainMenuTask(id+TASK_MENU)
				}
				else
				{
					if(get_pcvar_num(g_count))
					{
						g_player_time[id] = 0
						ShowTimer(id+TASK_TIMER)
					}

					params[0] = id
					params[1] = 4
					set_task(2.0, "KickPlayer", id+TASK_KICK, params, sizeof params)
				}
				client_printcolor(id, "%L", LANG_SERVER, "LOG_OUT", prefix)
			}
		}
		case 1:
		{
			client_cmd(id, "messagemode REGISTER_PASS")
		}
		case 3:
		{
			if(!is_logged[id])
				return PLUGIN_HANDLED

			if(cant_change_pass[id])
			{
				client_printcolor(id, "%L", LANG_SERVER, "CHANGE_TIMES", prefix, get_pcvar_num(g_chp_time))
				MainMenu(id)
				return PLUGIN_HANDLED
			}
			else
			{
				client_cmd(id, "messagemode CHANGE_PASS_NEW")
				MainMenu(id)
			}
		}
		case 4:
		{
			if(!is_logged[id])
			{
				MainMenu(id)
				return PLUGIN_HANDLED
			}

			if(is_autolog[id])
			{
				AutoLogin(id, false)
			}
			else
			{
				client_cmd(id, "messagemode AUTO_LOGIN_PASS")
			}
			MainMenu(id)
		}
		case 8:
		{
			Info(id)
			MainMenu(id)
		}
		case 9:
		{
			return PLUGIN_HANDLED
		}
	}
	return PLUGIN_HANDLED
}
/*==============================================================================
	End of the Main Menu function
================================================================================*/

/*==============================================================================
	Start of Login function
================================================================================*/
public Login(id)
{
	if(!get_pcvar_num(g_on))
		return PLUGIN_HANDLED

	if(!is_registered[id])
	{	
		client_printcolor(id, "%L", LANG_SERVER, "LOG_NOTREG", prefix)
		return PLUGIN_HANDLED
	}

	if(is_logged[id])
	{
		client_printcolor(id, "%L", LANG_SERVER, "LOG_LOGGED", prefix);
		return PLUGIN_HANDLED
	}
	
	read_args(typedpass, charsmax(typedpass))
	remove_quotes(typedpass)

	if(equal(typedpass, ""))
		return PLUGIN_HANDLED

	hash = convert_password(typedpass)

	if(!equal(hash, password[id]))
	{	
		TrieSetCell(g_login_times, g_client_data[id], ++attempts[id])
		client_printcolor(id, "%L", LANG_SERVER, "LOG_PASS_INVALID", prefix, attempts[id], get_pcvar_num(g_attempts))

		if(attempts[id] >= get_pcvar_num(g_attempts))
		{
			if(get_pcvar_num(g_count))
			{
				g_player_time[id] = 0
				ShowTimer(id+TASK_TIMER)
			}

			if(get_pcvar_num(g_time))
			{
				TrieSetCell(g_cant_login_time, g_client_data[id], time())
			}
			else
			{
				TrieSetCell(g_cant_login_time, g_client_data[id], 0)
			}
			params[0] = id
			params[1] = 3
			set_task(2.0, "KickPlayer", id+TASK_KICK, params, sizeof params)

			if(get_pcvar_num(g_time))
			{	
				set_task(get_pcvar_float(g_time), "RemoveCantLogin", 0, g_client_data[id], sizeof g_client_data)
			}
			return PLUGIN_HANDLED
		}
		else
		{
			client_cmd(id, "messagemode LOGIN_PASS")
		}
		return PLUGIN_HANDLED
	}
	else
	{
		is_logged[id] = true
		attempts[id] = 0
		remove_task(id+TASK_KICK)
		client_printcolor(id, "%L", LANG_SERVER, "LOG_LOGING", prefix)
		MainMenu(id)
		client_cmd(id, "jointeam")
	}
	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Login function
================================================================================*/

/*==============================================================================
	Start of Register function
================================================================================*/
public Register(id)
{
	if(!get_pcvar_num(g_on))
		return PLUGIN_HANDLED

	read_args(typedpass, charsmax(typedpass))
	remove_quotes(typedpass)

	new passlength = strlen(typedpass)

	if(equal(typedpass, ""))
		return PLUGIN_HANDLED
	
	if(is_registered[id])
	{
		client_printcolor(id, "%L", LANG_SERVER, "REG_EXISTS", prefix)
		return PLUGIN_HANDLED
	}

	if(passlength < get_pcvar_num(g_pass_length))
	{
		client_printcolor(id, "%L", LANG_SERVER, "REG_LEN", prefix, get_pcvar_num(g_pass_length))
		client_cmd(id, "messagemode REGISTER_PASS")
		return PLUGIN_HANDLED
	}

	new_pass[id] = typedpass
	remove_task(id+TASK_MENU)
	ConfirmPassword(id)
	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Register function
================================================================================*/

/*==============================================================================
	Start of Change Password function
================================================================================*/
public ChangePasswordNew(id)
{
	if(!get_pcvar_num(g_on) || !is_registered[id] || !is_logged[id])
		return PLUGIN_HANDLED

	if(cant_change_pass[id])
	{
		client_printcolor(id, "%L", LANG_SERVER, "CHANGE_TIMES", prefix, get_pcvar_num(g_chp_time))
		return PLUGIN_HANDLED
	}

	read_args(typedpass, charsmax(typedpass))
	remove_quotes(typedpass)

	new passlenght = strlen(typedpass)

	if(equal(typedpass, ""))
		return PLUGIN_HANDLED

	if(passlenght < get_pcvar_num(g_pass_length))
	{
		client_printcolor(id, "%L", LANG_SERVER, "REG_LEN", prefix, get_pcvar_num(g_pass_length))
		client_cmd(id, "messagemode CHANGE_PASS_NEW")
		return PLUGIN_HANDLED
	}

	new_pass[id] = typedpass
	client_cmd(id, "messagemode CHANGE_PASS_OLD")
	return PLUGIN_CONTINUE
}

public ChangePasswordOld(id)
{
	if(!get_pcvar_num(g_on) || !is_registered[id] || !is_logged[id])
		return PLUGIN_HANDLED

	if(cant_change_pass[id])
	{
		client_printcolor(id, "%L", LANG_SERVER, "CHANGE_TIMES", prefix, get_pcvar_num(g_chp_time))
		return PLUGIN_HANDLED
	}

	read_args(typedpass, charsmax(typedpass))
	remove_quotes(typedpass)

	if(equal(typedpass, "") || equal(new_pass[id], ""))
		return PLUGIN_HANDLED

	hash = convert_password(typedpass)

	if(!equali(hash, password[id]))
	{
		TrieSetCell(g_login_times, g_client_data[id], ++attempts[id])
		client_printcolor(id, "%L", LANG_SERVER, "LOG_PASS_INVALID", prefix, attempts[id], get_pcvar_num(g_attempts))

		if(attempts[id] >= get_pcvar_num(g_attempts))
		{
			if(get_pcvar_num(g_count))
			{
				g_player_time[id] = 0
				ShowTimer(id+TASK_TIMER)
			}
			
			if(get_pcvar_num(g_time))
			{
				TrieSetCell(g_cant_login_time, g_client_data[id], time())
			}
			else
			{
				TrieSetCell(g_cant_login_time, g_client_data[id], 0)
			}
			params[0] = id
			params[1] = 3
			set_task(2.0, "KickPlayer", id+TASK_KICK, params, sizeof params)

			if(get_pcvar_num(g_time))
			{	
				set_task(get_pcvar_float(g_time), "RemoveCantLogin", 0, g_client_data[id], sizeof g_client_data)
			}
			return PLUGIN_HANDLED
		}
		else
		{
			client_cmd(id, "messagemode CHANGE_PASS_OLD")
		}
		return PLUGIN_HANDLED
	}

	ConfirmPassword(id)
	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Change Password function
================================================================================*/

/*==============================================================================
	Start of Confirming Register's or Change Password's password function
================================================================================*/
public ConfirmPassword(id)
{
	if(!get_pcvar_num(g_on) || !is_user_connected(id))
		return PLUGIN_HANDLED

	length = 0
		
	formatex(menu, charsmax(menu) - length, "%L", LANG_SERVER, "MENU_PASS", new_pass[id])
	keys = MENU_KEY_1|MENU_KEY_2|MENU_KEY_0

	show_menu(id, keys, menu, -1, "Password Menu")
	return PLUGIN_CONTINUE
}

public HandlerConfirmPasswordMenu(id, key)
{
	switch(key)
	{
		case 0:
		{
			hash = convert_password(new_pass[id])

			if(is_registered[id])
			{
				if(get_pcvar_num(g_save))
				{
					formatex(text, charsmax(text), "UPDATE `registersystem` SET Password = ^"%s^", Status = ^"%s^" WHERE Name = ^"%s^";", hash, is_autolog[id] == true ? "LOGGED_IN" : "LOGGED_OUT", g_player_name[id])
					SQL_ThreadQuery(g_sqltuple, "QuerySetData", text)
				}
				else
				{
					line = 0, length = 0;

					while(read_file(reg_file, line++ , text, charsmax(text), length))
					{
						parse(text, text, charsmax(text))

						if(!(equal(text, g_player_name[id])))
							continue

						formatex(text, charsmax(text), "^"%s^" ^"%s^" ^"%s^"", g_player_name[id], hash, is_autolog[id] == true ? "LOGGED_IN" : "LOGGED_OUT")
						write_file(reg_file, text, line - 1)							

						break
					}
				}

				password[id] = hash
				TrieSetCell(g_pass_change_times, g_client_data[id], ++times[id])
				client_printcolor(id, "%L", LANG_SERVER, "CHANGE_NEW", prefix, new_pass[id])

				if(is_autolog[id])
				{
					get_pcvar_string(g_setinfo_pr, pass_prefix, charsmax(pass_prefix))
					client_cmd(id, "setinfo %s %s",pass_prefix, new_pass[id])
				}

				if(times[id] >= get_pcvar_num(g_chp_time))
				{
					cant_change_pass[id] = true
					
					if(get_pcvar_num(g_time_pass))
					{
						TrieSetCell(g_cant_change_pass_time, g_client_data[id], time())
					}
					else
					{
						TrieSetCell(g_cant_change_pass_time, g_client_data[id], 0)
					}

					if(get_pcvar_num(g_time_pass))
					{	
						set_task(get_pcvar_float(g_time), "RemoveCantChangePass", 0, g_client_data[id], sizeof g_client_data)
					}
				}

				if(get_pcvar_num(g_chp_log))
				{
					log_to_file(log_file, "%L", LANG_SERVER, "LOGFILE_CHNG_PASS", g_player_name[id])
				}

				MainMenu(id)
			}
			else
			{
				if(get_pcvar_num(g_save))
				{
					formatex(text, charsmax(text), "INSERT INTO `registersystem` (`Name`, `Password`, `Status`) VALUES (^"%s^", ^"%s^", ^"LOGGED_OUT^");", g_player_name[id], hash)
					SQL_ThreadQuery(g_sqltuple, "QuerySetData", text)
				}
				else
				{
					new file_pointer = fopen(reg_file, "a")
					format(text, charsmax(text), "^n^"%s^" ^"%s^" ^"^"", g_player_name[id], hash)
					fprintf(file_pointer, text)
					fclose(file_pointer)
				}

				is_registered[id] = true
				password[id] = hash
				new_pass[id] = ""
				
				if(get_pcvar_num(g_reg_log))
				{
					log_to_file(log_file, "%L", LANG_SERVER, "LOGFILE_REG", g_player_name[id])
				}
				
				if(is_user_connected(id))
				{
					user_silentkill(id)
					cs_set_user_team(id, CS_TEAM_UNASSIGNED)
					ShowMsg(id)
				}
			}
		}
		case 1:
		{
			if(is_registered[id])
			{
				client_cmd(id, "messagemode CHANGE_PASS_NEW")
			}
			else
			{
				client_cmd(id, "messagemode REGISTER_PASS")
				CreateMainMenuTask(id+TASK_MENU)
			}
		}
		case 9:
		{
			MainMenu(id)
			CreateMainMenuTask(id+TASK_MENU)
			return PLUGIN_HANDLED
		}
	}
	return PLUGIN_HANDLED
}

public QuerySetData(FailState, Handle:Query, error[],errcode, data[], datasize)
{
	if(FailState == TQUERY_CONNECT_FAILED || FailState == TQUERY_QUERY_FAILED)
	{
		log_amx("%s", error)
		return
	}
}
/*==============================================================================
	End of Confirming Register's or Change Password's password function
================================================================================*/

/*==============================================================================
	Start of Jointeam menus and commands functions
================================================================================*/
public HookTeamCommands(id)
{
	if(!get_pcvar_num(g_on) || !is_user_connected(id))
		return PLUGIN_CONTINUE
		
	if((!is_registered[id] && get_pcvar_float(g_regtime)) || (is_registered[id] && !is_logged[id]))
	{
		MainMenu(id)
		return PLUGIN_HANDLED
	}	
	else if(get_pcvar_num(g_ajc_change) && cs_get_user_team(id) != CS_TEAM_UNASSIGNED && (!get_pcvar_num(g_ajc_admin) || !(get_user_flags(id) & AJC_ADMIN_FLAG)))
	{
		return PLUGIN_HANDLED
	}	
	return PLUGIN_CONTINUE
}

public TextMenu(msgid, dest, id)
{
	if(!get_pcvar_num(g_on) || !is_user_connected(id))
		return PLUGIN_CONTINUE

	new menu_text[64];

	get_msg_arg_string(4, menu_text, charsmax(menu_text))

	if(equal(menu_text, JOIN_TEAM_MENU_FIRST) || equal(menu_text, JOIN_TEAM_MENU_FIRST_SPEC))
	{
		if((!is_registered[id] && get_pcvar_float(g_regtime)) || (is_registered[id] && !is_logged[id]))
		{
			MainMenu(id)
			return PLUGIN_HANDLED
		}
		else if((get_pcvar_num(g_ajc_team) && cs_get_user_team(id) == CS_TEAM_UNASSIGNED) && !task_exists(TASK_AJC) && (!get_pcvar_num(g_ajc_admin) || !(get_user_flags(id) & AJC_ADMIN_FLAG)))
		{
			SetAutoJoinTask(id, msgid)
			return PLUGIN_HANDLED
		}		
	}
	else if(equal(menu_text, JOIN_TEAM_MENU_INGAME) || equal(menu_text, JOIN_TEAM_MENU_INGAME_SPEC))
	{
		if((!is_registered[id] && get_pcvar_float(g_regtime)) || (is_registered[id] && !is_logged[id]))
		{
			MainMenu(id)
			return PLUGIN_HANDLED
		}
		else if(get_pcvar_num(g_ajc_change) && (!get_pcvar_num(g_ajc_admin) || !(get_user_flags(id) & AJC_ADMIN_FLAG)))
		{
			return PLUGIN_HANDLED
		}	
	}
	return PLUGIN_CONTINUE
}

public VGUIMenu(msgid, dest, id)
{
	if(!get_pcvar_num(g_on) || get_msg_arg_int(1) != JOIN_TEAM_VGUI_MENU || !is_user_connected(id))
		return PLUGIN_CONTINUE

	if((!is_registered[id] && get_pcvar_float(g_regtime)) || (is_registered[id] && !is_logged[id]))
	{
		MainMenu(id)
		return PLUGIN_HANDLED
	}	
	else if(get_pcvar_num(g_ajc_team))
	{
		if((!get_pcvar_num(g_ajc_admin) || !(get_user_flags(id) & AJC_ADMIN_FLAG)))
		{
			if(cs_get_user_team(id) == CS_TEAM_UNASSIGNED && !task_exists(TASK_AJC))
			{
				SetAutoJoinTask(id, msgid)
				return PLUGIN_HANDLED
			}
			else if(get_pcvar_num(g_ajc_change))
			{
				return PLUGIN_HANDLED
			}
		}
	}
	else if(get_pcvar_num(g_ajc_change) && (!get_pcvar_num(g_ajc_admin) || !(get_user_flags(id) & AJC_ADMIN_FLAG)))
	{
		return PLUGIN_HANDLED
	}	
	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Jointeam menus and commands functions
================================================================================*/

/*==============================================================================
	Start of Auto Join function
================================================================================*/
public AutoJoin(parameters[])
{
	new id = parameters[0]

	if(!is_user_connected(id))
		return PLUGIN_HANDLED
	
	if(cs_get_user_team(id) != CS_TEAM_UNASSIGNED)
		return PLUGIN_HANDLED

	new g_team[2], g_team_num = get_pcvar_num(g_ajc_team)

	if(g_team_num == 6)
	{
		num_to_str(g_team_num, g_team, charsmax(g_team))
		engclient_cmd(id, "jointeam", g_team)
		return PLUGIN_CONTINUE
	}

	if(g_team_num == 5)
	{
		g_team_num = random_num(1, 2)
	}
	else if(g_team_num != 1 && g_team_num != 2)
		return PLUGIN_HANDLED

	new g_class_num = get_pcvar_num(g_ajc_class[g_team_num - 1])
	num_to_str(g_team_num, g_team, charsmax(g_team))
	
	if(g_class_num == 5)
	{
		g_class_num = random_num(1, 4)
	}

	if(g_class_num == 0 || (g_class_num != 1 && g_class_num != 2 && g_class_num != 3 && g_class_num != 4))
	{
		engclient_cmd(id, "jointeam", g_team)
		return PLUGIN_CONTINUE
	}	

	new g_class[2], msg_block = get_msg_block(parameters[1])

	num_to_str(g_class_num, g_class, charsmax(g_class))

	set_msg_block(parameters[1], BLOCK_SET)
	engclient_cmd(id, "jointeam", g_team)
	engclient_cmd(id, "joinclass", g_class)
	set_msg_block(parameters[1], msg_block)

	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Auto Join functions
================================================================================*/

/*==============================================================================
	Start of Hook Client's commands
================================================================================*/
public client_command(id)
{
	if(get_pcvar_num(g_comm))
	{
		new command[64], arg[16];

		read_argv(0, command, charsmax(command))
		read_argv(1, arg, charsmax(arg))

		if((equali(command, "say") || equali(command, "say_team")) && equali(arg, "/reg"))
		{
			MainMenu(id)
			return PLUGIN_CONTINUE
		}

		if(TrieKeyExists(g_commands, command))
		{
			if(!is_registered[id] && get_pcvar_float(g_regtime))
			{
				console_print(id, "%s %L", prefix, LANG_SERVER, "COMMAND_REG")
				client_printcolor(id, "!g%s!t %L", prefix, LANG_SERVER, "COMMAND_REG")
				return PLUGIN_HANDLED
			}
			else if(is_registered[id] && !is_logged[id])
			{
				console_print(id, "%s %L", prefix, LANG_SERVER, "COMMAND_LOG")
				client_printcolor(id, "!g%s!t %L", prefix, LANG_SERVER, "COMMAND_LOG")
				return PLUGIN_HANDLED
			}	
		}
	}
	return PLUGIN_CONTINUE
}

/*==============================================================================
	End of Hook Client's commands
================================================================================*/

/*==============================================================================
	Start of Info/Help MOTD function
================================================================================*/
public Info(id)
{
	show_motd(id, "rshelpmotd.txt", "Register System Help")
}
/*==============================================================================
	End of Info/Help MOTD function
================================================================================*/

/*==============================================================================
	Start of Advret function
================================================================================*/
public ShowAdvert(id)
{
	id -= TASK_ADVERT
	
	if(!get_pcvar_num(g_on) || !get_pcvar_num(g_advert) || !is_user_connected(id) || is_registered[id])
		return PLUGIN_HANDLED

	client_printcolor(id, "%L", LANG_SERVER, "YOUCANREG_CHAT", prefix)
	set_task(get_pcvar_float(g_advert_int), "ShowAdvert", id+TASK_ADVERT)

	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Advret function
================================================================================*/

/*==============================================================================
	Start of Player Spawn function
================================================================================*/
public HookPlayerSpawn(id)
{
	if(get_pcvar_num(g_on) && is_user_connected(id))
	{
		show_menu(id, 0, "^n", 1)
	}
}
/*==============================================================================
	End of Player Spawn function
================================================================================*/

/*==============================================================================
	Start of Player PreThink function for the blind function
================================================================================*/
public PlayerPreThink(id)
{
	if(!get_pcvar_num(g_on) || !get_pcvar_num(g_blind) || !is_user_connected(id))
		return PLUGIN_HANDLED

	if((!is_registered[id] && get_pcvar_float(g_regtime)) || (is_registered[id] && !is_logged[id]))
	{
		message_begin(MSG_ONE_UNRELIABLE, g_screenfade, {0,0,0}, id)
		write_short(1<<12)
		write_short(1<<12)
		write_short(0x0000)
		write_byte(0)
		write_byte(0)
		write_byte(0)
		write_byte(255)
		message_end()
	}

	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Player PreThink function for the blind function
================================================================================*/

/*==============================================================================
	Start of Client Info Change function for hooking name change of clients
================================================================================*/
public ClientInfoChanged(id) 
{
	if(!get_pcvar_num(g_on) || !is_user_connected(id))
		return FMRES_IGNORED

	new oldname[32], newname[32];

	pev(id, pev_netname, oldname, charsmax(oldname))

	if(oldname[0])
	{
		get_user_info(id, "name", newname, charsmax(newname))
		replace_all(newname, charsmax(newname), "%", " ")

		if(!equal(oldname, newname))
		{
			if(name_change[id])
			{
				name_change[id] = false
				return FMRES_IGNORED
			}
			else if(is_logged[id])
			{
				set_user_info(id, "name", oldname)
				client_printcolor(id, "%L", LANG_SERVER, "NAME_CHANGE_LOG", prefix)
				name_change[id] = false
				return FMRES_HANDLED
			}
			else
			{
				g_player_name[id] = newname
				set_task(1.0, "CheckClient", id)

				if(!is_user_alive(id))
				{
					name_change[id] = true
				}
			}
		}
	}
	return FMRES_IGNORED
}
/*==============================================================================
	End of Client Info Change function for hooking name change of clients
================================================================================*/

/*==============================================================================
	Start of Kick Player function
================================================================================*/
public KickPlayer(parameters[])
{
	new id = parameters[0]
	new reason = parameters[1]

	if(!is_user_connecting(id) && !is_user_connected(id))
		return PLUGIN_HANDLED

	new userid = get_user_userid(id)

	switch(reason)
	{
		case 1:
		{
			if(is_registered[id])
				return PLUGIN_HANDLED

			console_print(id, "%L", LANG_SERVER, "KICK_INFO")
			server_cmd("kick #%i ^"%L^"", userid, LANG_PLAYER, "KICK_REG")
		}
		case 2:
		{
			if(is_logged[id])
				return PLUGIN_HANDLED

			console_print(id, "%L", LANG_SERVER, "KICK_INFO")
			server_cmd("kick #%i ^"%L^"", userid, LANG_PLAYER, "KICK_LOGIN")
		}
		case 3:
		{
			if(TrieGetCell(g_cant_login_time, g_client_data[id], value))
			{
				console_print(id, "%L", LANG_SERVER, "KICK_INFO")

				if(!value)
				{
					server_cmd("kick #%i ^"%s^"", userid, LANG_PLAYER, "KICK_ATMP_MAP", get_pcvar_num(g_attempts))
				}
				else
				{
					new cal_time = get_pcvar_num(g_time) - (time() - value)
					server_cmd("kick #%i ^"%s^"", userid, LANG_PLAYER, "KICK_ATMP_TIME", get_pcvar_num(g_attempts), cal_time)
				}
			}
		}
		case 4:
		{
			console_print(id, "%L", LANG_SERVER, "KICK_INFO")
			server_cmd("kick #%i ^"%L^"", userid, LANG_SERVER, "KICK_LOGOUT")
		}
	}
	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Kick Player function
================================================================================*/

/*==============================================================================
	Start of Removing Punishes function
================================================================================*/
public RemoveCantLogin(data[])
{
	TrieDeleteKey(g_login_times, data)
	TrieDeleteKey(g_cant_login_time, data)
}

public RemoveCantChangePass(data[])
{
	TrieDeleteKey(g_cant_change_pass_time, data)
	TrieDeleteKey(g_pass_change_times, data)

	new target;
	
	switch(get_pcvar_num(g_member))
	{
		case 0:
		{
			target = find_player("a", data)
		}
		case 1:
		{
			target = find_player("d", data)
		}
		case 2:
		{
			target = find_player("c", data)
		}
		default:
		{
			target = find_player("a", data)
		}
	}

	if(!target)
		return PLUGIN_HANDLED

	cant_change_pass[target] = false
	client_printcolor(target, "%L", LANG_SERVER, "CHANGE_CAN", prefix)
	return PLUGIN_CONTINUE
}
/*==============================================================================
	End of Removing Punish function
================================================================================*/

/*==============================================================================
	Start of Plugin's stocks
================================================================================*/
stock client_printcolor(const id, const message[], any:...)
{
	new g_message[191];

	vformat(g_message, charsmax(g_message), message, 3)

	replace_all(g_message, charsmax(g_message), "!g", "^4")
	replace_all(g_message, charsmax(g_message), "!n", "^1")
	replace_all(g_message, charsmax(g_message), "!t", "^3")

	if(is_user_connected(id))
	{
		message_begin(MSG_ONE_UNRELIABLE, g_saytxt,_, id)
		write_byte(id)
		write_string(g_message)
		message_end()
	}
}

stock convert_password(const password[])
{
	new pass_salt[64], converted_password[34];

	formatex(pass_salt, charsmax(pass_salt), "%s%s", password, SALT)
	md5(pass_salt, converted_password)
	
	return converted_password
}

stock SetAutoJoinTask(id, menu_msgid)
{
	params[0] = id
	params[1] = menu_msgid

	set_task(AJC_TASK_TIME, "AutoJoin", id+TASK_AJC, params, sizeof params)
}
/*==============================================================================
	End of Plugin's stocks
================================================================================*/